 @extends('layouts.landing')
 @section('page-title')
 {{ __('Manage Leave Type') }}
 @endsection
 @push('css')
 <style>
     .mano {
         display: flex;
         flex-direction: row;
         justify-content: end;
     }

     .alpha {
         font-size: 28px;
         font-weight: 500;
         letter-spacing: 1px;
     }

     .icon01 {
         color: #3cd665;
     }

     .icon001 {
         color: #ed3915;
     }

     .manu001 {
         margin-bottom: -12.5px;
     }

     .head01 {
         font-size: 42px !important;
         white-space: nowrap;

     }

     .span368 {
         color: #FF6B52;
     }

     .span369 {
         color: #FF6B52;
         font-weight: 800;
     }
 </style>
 @endpush
 @section('content')

 <section class="top-h1">
     <div class="container">
         <div class="space-90"></div>
         <div class="row">
             <div class="col-lg-12 text-center">
                 <h2 class="head01" id="animateText">Managing Your Business <span class="span368">Effectively,</span><br>Easier than Ever Before</h2>
                 <p><span class="span368">ERPGo</span> gives you all you need to better organize and manage yourbusiness growth<br> <span class="span369">Try 7 Days Free Trial</span></p>
                 <div class="space-10"></div>
                 <div class="space-5"></div>
                 <div class="ot-button">
                     <a href="{{ route('register') }}" class="octf-btn octf-btn-main">Get Free Trail</a>
                 </div>
                 <div class="space-70"></div>
                 <div class="space-5"></div>
                 <div class="space-2"></div>
                 <img src="{{ asset('assets/landing/images/image1-home1.png') }}" alt="">
             </div>
         </div>
         <div class="space-90"></div>
     </div>
 </section>

 <section>
     <div class="container">
         <div class="row">
             <div class="col-lg-12 text-center">
                 <div class="ssub-yes">
                     <div class="ot-heading">
                         <span class="ot-heading__sub">What We provide</span>
                         <h2 class="ot-heading__title">Salient Features of ERPGo SaaS – All In One Business ERP With Project, Account, HRM & CRM</h2>
                     </div>
                 </div>
                 <div class="space-40"></div>
             </div>
         </div>
         <div class="row">
             <div class="col-lg-3 col-md-6 col-sm-6 mb-4">
                 <div class="ot-icon-box services-list-icon services-h1">
                     <div class="ot-icon-box__icon">
                         <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                             <linearGradient id="protecttion_SVGID_1_" gradientUnits="userSpaceOnUse" x1="171.8584" y1="373.8224" x2="570.7385" y2="-25.0576" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#62E1FB"></stop>
                                 <stop offset="1" style="stop-color:#00A2F3"></stop>
                             </linearGradient>
                             <path style="fill:url(#protecttion_SVGID_1_);" d="M490.437,123.627c-0.159-11.453-8.759-20.995-20.119-22.463  c-104.84-13.551-177.63-72.627-203.704-96.98c-5.973-5.579-15.257-5.579-21.23,0c-26.074,24.353-98.863,83.429-203.704,96.98  c-11.359,1.468-19.96,11.011-20.119,22.463C20.526,198.626,33.467,456.367,256,512C478.534,456.367,491.475,198.626,490.437,123.627  z"></path>
                             <linearGradient id="protecttion_SVGID_2_" gradientUnits="userSpaceOnUse" x1="447.2291" y1="259.543" x2="178.8491" y2="259.543" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#00A2F3;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#0075CD"></stop>
                             </linearGradient>
                             <path style="fill:url(#protecttion_SVGID_2_);" d="M287.674,502.235c1.559-0.577,3.107-1.165,4.643-1.763c1.984-0.773,3.948-1.564,5.893-2.373  c1.279-0.532,2.55-1.072,3.812-1.618c1.988-0.861,3.958-1.738,5.905-2.636c0.732-0.337,1.459-0.679,2.185-1.021  c1.795-0.847,3.571-1.711,5.33-2.588c2.553-1.273,5.07-2.577,7.549-3.912c2.369-1.276,4.712-2.575,7.015-3.907  c2.645-1.53,5.245-3.096,7.805-4.696c0.058-0.037,0.118-0.072,0.178-0.108c4.868-3.048,9.575-6.226,14.139-9.515  c0.343-0.247,0.692-0.49,1.033-0.738c3.331-2.424,6.575-4.915,9.747-7.459c0.316-0.253,0.638-0.503,0.952-0.757  c1.796-1.454,3.56-2.932,5.306-4.423c1.628-1.39,3.243-2.79,4.828-4.211c0.536-0.48,1.061-0.968,1.592-1.451  c0.555-0.505,1.114-1.007,1.664-1.517c1.634-1.514,3.239-3.049,4.826-4.595c0.501-0.488,1.007-0.972,1.503-1.463  c1.721-1.702,3.408-3.425,5.076-5.163c0.337-0.351,0.681-0.701,1.016-1.053c1.963-2.068,3.887-4.16,5.776-6.276  c0.027-0.031,0.055-0.061,0.083-0.091c2.391-2.681,4.716-5.403,6.99-8.156c1.367-1.654,2.721-3.318,4.047-4.997  c2.618-3.315,5.154-6.677,7.614-10.078c0.028-0.038,0.056-0.076,0.084-0.115c0.577-0.799,1.143-1.602,1.713-2.405  c0.248-0.35,0.501-0.699,0.747-1.05c0.399-0.568,0.788-1.14,1.183-1.711c0.408-0.59,0.82-1.179,1.225-1.771  c1.318-1.936,2.606-3.885,3.877-5.843c1.788-2.756,3.536-5.531,5.231-8.328c2.088-3.442,4.104-6.915,6.057-10.412  c0.082-0.149,0.168-0.295,0.25-0.444c0.434-0.779,0.858-1.562,1.285-2.343c0.239-0.438,0.483-0.873,0.72-1.312  c1.216-2.248,2.401-4.507,3.563-6.772c0.1-0.196,0.204-0.392,0.304-0.587c0.469-0.919,0.93-1.84,1.389-2.762  c0.157-0.314,0.317-0.626,0.474-0.941c0.253-0.509,0.498-1.02,0.748-1.53c1.572-3.204,3.098-6.422,4.569-9.654  c2.599-5.708,5.04-11.453,7.339-17.214c0.718-1.799,1.427-3.599,2.116-5.4c1.819-4.751,3.538-9.51,5.168-14.268  c0.101-0.297,0.207-0.593,0.308-0.89c0.309-0.909,0.611-1.817,0.914-2.727c0.118-0.354,0.24-0.709,0.356-1.063  c1.151-3.486,2.251-6.969,3.308-10.446c0.092-0.303,0.188-0.607,0.279-0.912c0.556-1.844,1.095-3.685,1.625-5.525  c0.592-2.052,1.171-4.102,1.732-6.148c0.839-3.064,1.642-6.119,2.413-9.163c0.46-1.812,0.912-3.622,1.347-5.425  c0.193-0.797,0.379-1.591,0.568-2.387c0.104-0.44,0.211-0.88,0.314-1.32c0.508-2.171,0.997-4.334,1.473-6.49  c0.065-0.295,0.133-0.59,0.197-0.885c0.394-1.8,0.773-3.592,1.144-5.38c0.209-1.005,0.416-2.008,0.617-3.009  c0.407-2.012,0.802-4.017,1.182-6.01c0.009-0.047,0.019-0.095,0.027-0.143c0.354-1.865,0.695-3.721,1.027-5.569  c0.308-1.716,0.61-3.426,0.9-5.126c0.337-1.979,0.659-3.943,0.97-5.899c0.059-0.371,0.12-0.745,0.179-1.115  c0.052-0.329,0.1-0.655,0.152-0.984c0.128-0.828,0.258-1.657,0.383-2.481c0.304-2.011,0.593-4.006,0.872-5.987  c0.04-0.288,0.083-0.578,0.123-0.865c0.102-0.739,0.202-1.473,0.301-2.208c0.053-0.391,0.107-0.783,0.16-1.172  c0.044-0.332,0.085-0.661,0.13-0.991c0.399-3.027,0.771-6.018,1.114-8.966c0.751-6.443,1.373-12.688,1.888-18.698  c0.008-0.09,0.016-0.183,0.024-0.273c0.129-1.504,0.248-2.989,0.362-4.462c0.057-0.74,0.114-1.478,0.169-2.21  c0.254-3.408,0.473-6.729,0.661-9.959c0.071-1.226,0.141-2.444,0.203-3.641c0.132-2.501,0.243-4.936,0.339-7.313  c0.028-0.699,0.055-1.391,0.08-2.079c0.139-3.729,0.238-7.295,0.304-10.677c0.001-0.061,0.003-0.124,0.004-0.186  c0.072-3.784,0.104-7.336,0.106-10.641c0-0.066,0-0.136,0-0.202c0.001-2.689-0.018-5.21-0.05-7.554  c-0.159-11.455-8.76-20.998-20.122-22.467c-2.924-0.378-5.815-0.804-8.688-1.251c-0.637-0.099-1.275-0.198-1.909-0.3  c-2.801-0.452-5.582-0.93-8.334-1.444c-0.413-0.077-0.819-0.161-1.23-0.239c-2.501-0.477-4.98-0.979-7.441-1.505  c-0.529-0.112-1.06-0.222-1.587-0.337c-2.681-0.585-5.337-1.2-7.968-1.839c-0.553-0.135-1.101-0.274-1.652-0.411  c-2.433-0.604-4.845-1.227-7.233-1.875c-0.31-0.084-0.623-0.164-0.933-0.248c-2.593-0.711-5.154-1.452-7.696-2.211  c-0.577-0.173-1.152-0.346-1.727-0.521c-2.544-0.774-5.07-1.563-7.561-2.381c-0.136-0.044-0.268-0.091-0.404-0.136  c-2.397-0.791-4.764-1.605-7.111-2.435c-0.532-0.188-1.066-0.374-1.596-0.565c-2.389-0.856-4.756-1.729-7.092-2.62  c-0.398-0.152-0.789-0.307-1.186-0.46c-2.114-0.816-4.206-1.645-6.276-2.488c-0.409-0.167-0.821-0.33-1.228-0.497  c-2.27-0.934-4.51-1.882-6.724-2.844c-0.483-0.21-0.961-0.421-1.441-0.631c-2.09-0.919-4.161-1.845-6.201-2.786  c-0.186-0.085-0.374-0.169-0.559-0.255c-2.172-1.006-4.309-2.026-6.424-3.054c-0.479-0.233-0.956-0.466-1.433-0.699  c-2.091-1.026-4.161-2.06-6.194-3.104c-0.202-0.103-0.398-0.209-0.599-0.312c-1.898-0.979-3.768-1.966-5.615-2.957  c-0.417-0.224-0.834-0.446-1.249-0.67c-1.944-1.052-3.859-2.108-5.744-3.169c-0.356-0.201-0.707-0.403-1.061-0.603  c-1.702-0.965-3.38-1.933-5.033-2.903c-0.295-0.174-0.595-0.346-0.889-0.52c-1.817-1.073-3.6-2.147-5.358-3.223  c-0.394-0.241-0.783-0.482-1.174-0.723c-1.723-1.062-3.425-2.125-5.09-3.186c-0.056-0.036-0.114-0.072-0.172-0.108  c-1.714-1.094-3.386-2.186-5.037-3.275c-0.37-0.245-0.74-0.489-1.107-0.733c-1.606-1.067-3.188-2.132-4.732-3.19  c-0.207-0.142-0.407-0.282-0.612-0.424c-1.412-0.972-2.794-1.938-4.152-2.898c-0.3-0.213-0.603-0.426-0.902-0.637  c-1.459-1.038-2.886-2.068-4.282-3.089c-0.287-0.211-0.568-0.419-0.852-0.627c-1.268-0.934-2.512-1.859-3.728-2.776  c-0.182-0.138-0.369-0.276-0.55-0.414c-1.327-1.005-2.616-1.997-3.878-2.978c-0.289-0.225-0.573-0.447-0.859-0.671  c-1.258-0.984-2.495-1.959-3.686-2.914c-0.025-0.02-0.048-0.039-0.073-0.059c-1.183-0.949-2.32-1.877-3.435-2.794  c-0.25-0.206-0.5-0.411-0.747-0.614c-1.091-0.903-2.154-1.79-3.179-2.656c-0.164-0.139-0.318-0.271-0.48-0.409  c-0.925-0.785-1.82-1.554-2.689-2.307c-0.18-0.156-0.363-0.314-0.541-0.469c-0.942-0.819-1.847-1.616-2.721-2.394  c-0.187-0.167-0.366-0.327-0.55-0.492c-0.798-0.714-1.572-1.411-2.312-2.084c-0.088-0.08-0.182-0.165-0.269-0.244  c-0.798-0.729-1.551-1.425-2.278-2.102c-0.074-0.07-0.161-0.148-0.235-0.217C263.629,1.394,259.814,0,256,0v512  c4.936-1.234,9.764-2.572,14.496-4.001C276.378,506.223,282.1,504.297,287.674,502.235z"></path>
                             <linearGradient id="protecttion_SVGID_3_" gradientUnits="userSpaceOnUse" x1="175.201" y1="366.765" x2="393.2611" y2="148.705" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#A7F3CE"></stop>
                                 <stop offset="1" style="stop-color:#61DB99"></stop>
                             </linearGradient>
                             <path style="fill:url(#protecttion_SVGID_3_);" d="M462.637,139.324c-0.14-10.094-7.72-18.505-17.732-19.799  c-92.408-11.944-156.566-64.014-179.547-85.479c-5.265-4.917-13.448-4.917-18.712,0c-22.982,21.465-87.139,73.535-179.547,85.479  c-10.012,1.294-17.593,9.705-17.732,19.799C48.45,205.429,59.856,432.606,256,481.642  C452.145,432.606,463.551,205.429,462.637,139.324z"></path>
                             <path style="fill:#FFFFFF;" d="M256,464.258l-2.313-0.578c-41.606-10.402-77.193-30.464-105.772-59.63  c-23.724-24.212-42.787-54.862-56.661-91.098c-24.11-62.972-26.953-127.078-26.502-159.687  c0.186-13.504,10.463-24.997,23.903-26.734c78.347-10.127,132.824-54.202,152.609-72.682c8.262-7.718,21.208-7.717,29.471-0.001  c19.785,18.481,74.262,62.556,152.608,72.683c13.442,1.738,23.719,13.232,23.904,26.734  c0.851,61.527-10.256,265.745-188.935,310.416L256,464.258z M256,67.106c-0.619,0-1.238,0.225-1.721,0.676  c-21.134,19.739-79.339,66.821-163.179,77.657c-4.094,0.529-7.225,4.008-7.282,8.089C83.02,211.239,93.137,402.105,256,444.59  c162.863-42.485,172.981-233.351,172.183-291.062l0,0c-0.057-4.082-3.187-7.56-7.283-8.089  c-83.839-10.836-142.045-57.918-163.178-77.657C257.238,67.331,256.62,67.106,256,67.106z"></path>
                             <linearGradient id="protecttion_SVGID_4_" gradientUnits="userSpaceOnUse" x1="427.8791" y1="259.543" x2="159.679" y2="259.543" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#61DB99;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#009E74"></stop>
                             </linearGradient>
                             <path style="fill:url(#protecttion_SVGID_4_);" d="M462.637,139.324c-0.14-10.094-7.72-18.505-17.732-19.799  c-92.408-11.944-156.566-64.014-179.547-85.479c-2.632-2.459-5.994-3.688-9.357-3.688v451.285  C452.145,432.606,463.551,205.429,462.637,139.324z"></path>
                             <linearGradient id="protecttion_SVGID_5_" gradientUnits="userSpaceOnUse" x1="403.5391" y1="163.033" x2="301.3791" y2="265.193" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#61DB99;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#009E74"></stop>
                             </linearGradient>
                             <path style="fill:url(#protecttion_SVGID_5_);" d="M473.862,271.119c-16.494,66.68-48.831,139.224-111.465,189.179L168.318,266.22  c-7.098-7.098-7.098-18.613,0-25.72c7.098-7.108,18.623-7.108,25.72,0l39.043,39.043c4.809,4.799,12.639,4.799,17.428,0  L353.542,176.52c7.108-7.108,18.623-7.108,25.72,0h0.01L473.862,271.119z"></path>
                             <linearGradient id="protecttion_SVGID_6_" gradientUnits="userSpaceOnUse" x1="272.5345" y1="297.083" x2="272.5345" y2="178.673" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#FFF465"></stop>
                                 <stop offset="1" style="stop-color:#FFE600"></stop>
                             </linearGradient>
                             <path style="fill:url(#protecttion_SVGID_6_);" d="M379.271,176.523c7.104,7.104,7.103,18.62-0.001,25.723l-103.032,103.02  c-18.991,18.992-49.895,18.992-68.873,0l-39.045-39.045c-7.102-7.102-7.104-18.616-0.003-25.719l0,0  c7.103-7.106,18.621-7.108,25.725-0.003l39.038,39.038c4.805,4.805,12.635,4.805,17.428,0l103.033-103.022  c7.103-7.103,18.619-7.102,25.721,0.001L379.271,176.523z"></path>
                         </svg>
                     </div>
                     <div class="space-4"></div>
                     <div class="ot-icon-box__content">
                         <h3 class="icon-box-title">Manage Staff</h3>
                         <div class="space-3"></div>
                         <div class="icon-box-des">Manage your Employee and Client’s personal as well as company details through easy-to-create options. You can edit and manage the information and status at your convenience.</div>
                     </div>
                 </div>
                 <div class="space-30 d-lg-none"></div>
             </div>
             <div class="col-lg-3 col-md-6 col-sm-6">
                 <div class="ot-icon-box services-list-icon services-h1">
                     <div class="ot-icon-box__icon">
                         <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 510 510">
                             <linearGradient id="target_SVGID_1_" gradientUnits="userSpaceOnUse" x1="-12" x2="504.14" y1="255" y2="255">
                                 <stop offset="0" stop-color="#fe99a0"></stop>
                                 <stop offset=".593" stop-color="#fe646f"></stop>
                                 <stop offset="1" stop-color="#e41f2d"></stop>
                             </linearGradient>
                             <linearGradient id="target_SVGID_2_" gradientUnits="userSpaceOnUse" x1="257.617" x2="536.607" y1="255" y2="255">
                                 <stop offset="0" stop-color="#fe646f"></stop>
                                 <stop offset=".7043" stop-color="#e41f2d"></stop>
                                 <stop offset="1" stop-color="#c41926"></stop>
                             </linearGradient>
                             <linearGradient id="target_SVGID_3_" gradientUnits="userSpaceOnUse" x1="74" x2="430.14" y1="255" y2="255">
                                 <stop offset="0" stop-color="#f2fbff"></stop>
                                 <stop offset=".593" stop-color="#faf7f7"></stop>
                                 <stop offset="1" stop-color="#f3eae6"></stop>
                             </linearGradient>
                             <linearGradient id="lg1">
                                 <stop offset="0" stop-color="#f3eae6"></stop>
                                 <stop offset="1" stop-color="#cdbfba"></stop>
                             </linearGradient>
                             <linearGradient id="target_SVGID_5_" gradientUnits="userSpaceOnUse" x1="207" x2="431.154" xlink:href="#lg1" y1="261.37" y2="261.37"></linearGradient>
                             <linearGradient id="target_SVGID_6_" gradientUnits="userSpaceOnUse" x1="207" x2="431.154" xlink:href="#lg1" y1="166.885" y2="166.885"></linearGradient>
                             <linearGradient id="lg2">
                                 <stop offset="0" stop-color="#fff9df"></stop>
                                 <stop offset=".593" stop-color="#ffe177"></stop>
                                 <stop offset="1" stop-color="#feb137"></stop>
                             </linearGradient>
                             <linearGradient id="target_SVGID_7_" gradientUnits="userSpaceOnUse" x1="357" x2="511.029" xlink:href="#lg2" y1="75.395" y2="75.395"></linearGradient>
                             <linearGradient id="target_SVGID_8_" gradientUnits="userSpaceOnUse" x1="345.333" x2="515.016" xlink:href="#lg2" y1="75.395" y2="75.395"></linearGradient>
                             <linearGradient id="target_SVGID_9_" gradientUnits="userSpaceOnUse" x1="345.333" x2="480" xlink:href="#lg2" y1="64.562" y2="64.562"></linearGradient>
                             <linearGradient id="target_SVGID_10_" gradientUnits="userSpaceOnUse" x1="345.333" x2="452" xlink:href="#lg2" y1="53.729" y2="53.729"></linearGradient>
                             <linearGradient id="target_SVGID_11_" gradientUnits="userSpaceOnUse" x1="237.5" x2="469.443" y1="156.528" y2="156.528">
                                 <stop offset="0" stop-color="#01d0fb"></stop>
                                 <stop offset=".6075" stop-color="#26a6fe"></stop>
                                 <stop offset="1" stop-color="#0182fc"></stop>
                             </linearGradient>
                             <g>
                                 <circle cx="255" cy="255" fill="url(#target_SVGID_1_)" r="255"></circle>
                                 <path d="m255 0c-6.735 0-13.408.266-20.012.778 58.536 4.544 111.517 28.865 152.299 66.272l-8.952 8.952c-7.963 7.963-11.183 19.509-8.491 30.444l8.097 32.882-128.118 128.12-12.323-12.323v32.125h.011c.058 4.401 1.756 8.785 5.115 12.144 3.417 3.417 7.896 5.125 12.375 5.125s8.958-1.708 12.375-5.125l125.614-125.615 32.882 8.097c10.935 2.692 22.481-.528 30.444-8.491l.227-.227c8.701 25.69 13.434 53.212 13.434 81.842 0 134.097-103.51 244.014-234.988 254.222 6.603.512 13.276.778 20.011.778 140.833 0 255-114.167 255-255s-114.167-255-255-255z" fill="url(#target_SVGID_2_)"></path>
                                 <g fill="url(#target_SVGID_3_)">
                                     <circle cx="255" cy="255" r="30"></circle>
                                     <path d="m255 75c-99.411 0-180 80.589-180 180s80.589 180 180 180 180-80.589 180-180-80.589-180-180-180zm0 285c-57.99 0-105-47.01-105-105s47.01-105 105-105 105 47.01 105 105-47.01 105-105 105z"></path>
                                 </g>
                                 <g>
                                     <path d="m249.82 267.45-12.32-12.33v24.24c4.92 3.55 10.97 5.64 17.5 5.64 16.57 0 30-13.43 30-30 0-6.42-2.02-12.38-5.47-17.26z" fill="url(#target_SVGID_5_)"></path>
                                     <path d="m372.93 119.01 5.01 20.32-45.14 45.14c8.02 8.85 14.56 19.08 19.21 30.29l40.98-40.98 25.74 6.34c-10.78-23.54-26.49-44.35-45.8-61.11z" fill="url(#target_SVGID_6_)"></path>
                                 </g>
                                 <path d="m499.383 68.38-46.349-11.413-11.413-46.349c-2.596-10.543-15.716-14.203-23.395-6.525l-49.592 49.592c-7.963 7.963-11.183 19.509-8.491 30.444l12.987 52.741 52.741 12.987c10.935 2.692 22.481-.528 30.444-8.491l49.592-49.592c7.678-7.678 4.019-20.798-6.524-23.394z" fill="url(#target_SVGID_7_)"></path>
                                 <path d="m499.383 68.38-46.349-11.413-11.413-46.349c-2.596-10.543-15.716-14.203-23.395-6.525l-49.592 49.592c-7.963 7.963-11.183 19.509-8.491 30.444l12.987 52.741 52.741 12.987c10.935 2.692 22.481-.528 30.444-8.491l49.592-49.592c7.678-7.678 4.019-20.798-6.524-23.394z" fill="url(#target_SVGID_8_)"></path>
                                 <path d="m499.383 68.38-46.349-11.413-11.413-46.349c-2.596-10.543-15.715-14.202-23.393-6.526l-27.926 27.926c-7.963 7.963-11.183 19.51-8.491 30.444l12.987 52.741 52.741 12.987c10.935 2.692 22.481-.528 30.444-8.491l27.925-27.925c7.677-7.678 4.018-20.798-6.525-23.394z" fill="url(#target_SVGID_9_)"></path>
                                 <path d="m499.383 68.38-46.349-11.413-11.413-46.349c-2.596-10.542-15.714-14.202-23.392-6.527l-6.261 6.261c-7.963 7.963-11.183 19.509-8.491 30.444l12.987 52.741 52.741 12.987c10.935 2.692 22.481-.528 30.444-8.491l6.258-6.258c7.678-7.679 4.019-20.799-6.524-23.395z" fill="url(#target_SVGID_10_)"></path>
                                 <path d="m255 272.5c-4.479 0-8.957-1.708-12.375-5.125-6.834-6.834-6.834-17.915 0-24.749l196.944-196.944c6.834-6.834 17.914-6.834 24.749 0 6.834 6.834 6.834 17.915 0 24.749l-196.943 196.944c-3.417 3.417-7.896 5.125-12.375 5.125z" fill="url(#target_SVGID_11_)"></path>
                             </g>
                         </svg>
                     </div>
                     <div class="space-4"></div>
                     <div class="ot-icon-box__content">
                         <h3 class="icon-box-title">Payroll</h3>
                         <div class="space-3"></div>
                         <div class="icon-box-des">With the help of the Payroll module, the set salary feature will help you to set the salary of your employees, particularly under various different heads set by you.</div>
                     </div>
                 </div>
                 <div class="space-30 d-lg-none"></div>
             </div>
             <div class="col-lg-3 col-md-6 col-sm-6">
                 <div class="ot-icon-box services-list-icon services-h1">
                     <div class="ot-icon-box__icon">
                         <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                             <linearGradient id="fb1_SVGID_1_" gradientUnits="userSpaceOnUse" x1="233.9092" y1="411.5636" x2="274.5492" y2="318.6936" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#FFE7A5"></stop>
                                 <stop offset="1" style="stop-color:#FFBF5C"></stop>
                             </linearGradient>
                             <path style="fill:url(#fb1_SVGID_1_);" d="M313.093,92.571c-2.918,32.805-10.882,64.419-23.891,94.709H180.92  c26.421-40.011,38.787-81.893,37.771-128.434c-0.306-14.783,10.398-27.517,24.987-29.904c0.322-0.048,0.628-0.096,0.952-0.146  C282.802,22.558,316.494,54.026,313.093,92.571z"></path>
                             <linearGradient id="fb1_SVGID_2_" gradientUnits="userSpaceOnUse" x1="257.2702" y1="220.3267" x2="507.7102" y2="103.4567" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#FFE7A5"></stop>
                                 <stop offset="1" style="stop-color:#FFBF5C"></stop>
                             </linearGradient>
                             <path style="fill:url(#fb1_SVGID_2_);" d="M466.887,179.642l-346.774-0.015v268.858h123.775h162.372h13.497  c35.134,0,65.12-25.398,70.902-60.054l20.715-156.265C515.961,204.672,494.76,179.642,466.887,179.642z"></path>
                             <linearGradient id="fb1_SVGID_3_" gradientUnits="userSpaceOnUse" x1="410.9186" y1="201.7148" x2="152.0086" y2="201.7148" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#FFE7A5;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#FFBF5C"></stop>
                             </linearGradient>
                             <path style="fill:url(#fb1_SVGID_3_);" d="M406.261,448.485h13.497c24.736,0,46.906-12.599,59.889-32.145l-294.8-236.712l-64.735-0.003  v268.858h123.776L406.261,448.485z"></path>
                             <linearGradient id="fb1_SVGID_4_" gradientUnits="userSpaceOnUse" x1="134.2192" y1="262.6935" x2="233.2292" y2="-31.6365" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#F2F2F2"></stop>
                                 <stop offset="1" style="stop-color:#C3C3C3"></stop>
                             </linearGradient>
                             <path style="fill:url(#fb1_SVGID_4_);" d="M171.587,464.925h-32.112c-7.75,0-14.033-6.283-14.033-14.033V177.22  c0-7.75,6.283-14.033,14.033-14.033h32.112c7.75,0,14.033,6.283,14.033,14.033v273.672  C185.62,458.643,179.338,464.925,171.587,464.925z"></path>
                             <linearGradient id="fb1_SVGID_5_" gradientUnits="userSpaceOnUse" x1="151.5253" y1="197.3172" x2="46.8353" y2="247.9773" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#C3C3C3;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#777777"></stop>
                             </linearGradient>
                             <path style="fill:url(#fb1_SVGID_5_);" d="M150.124,163.186h-10.65c-7.75,0-14.033,6.283-14.033,14.033v273.673  c0,7.75,6.283,14.033,14.033,14.033h32.112c7.75,0,14.033-6.283,14.033-14.033V198.68L150.124,163.186z"></path>
                             <linearGradient id="fb1_SVGID_6_" gradientUnits="userSpaceOnUse" x1="60.6603" y1="239.2635" x2="180.5493" y2="-85.3864" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#62E1FB"></stop>
                                 <stop offset="1" style="stop-color:#00A2F3"></stop>
                             </linearGradient>
                             <path style="fill:url(#fb1_SVGID_6_);" d="M135.388,483.996H14.634C6.552,483.996,0,477.444,0,469.362V158.749  c0-8.082,6.552-14.634,14.634-14.634h120.754c8.083,0,14.634,6.552,14.634,14.634v310.612  C150.022,477.444,143.47,483.996,135.388,483.996z"></path>
                             <linearGradient id="fb1_SVGID_7_" gradientUnits="userSpaceOnUse" x1="123.6008" y1="254.9955" x2="20.5598" y2="358.0355" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#00A2F3;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#0075CD"></stop>
                             </linearGradient>
                             <path style="fill:url(#fb1_SVGID_7_);" d="M150.022,234.163l-47.821-47.821c-6.747-7.347-16.429-11.955-27.19-11.955  c-20.386,0-36.912,16.527-36.912,36.912c0,10.761,4.608,20.444,11.955,27.19l99.969,99.968V234.163z"></path>
                             <linearGradient id="fb1_SVGID_8_" gradientUnits="userSpaceOnUse" x1="74.5286" y1="327.1533" x2="74.5286" y2="273.9833" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#FFF465"></stop>
                                 <stop offset="1" style="stop-color:#FFE600"></stop>
                             </linearGradient>
                             <circle style="fill:url(#fb1_SVGID_8_);" cx="75.013" cy="211.296" r="36.912"></circle>
                             <linearGradient id="fb1_SVGID_9_" gradientUnits="userSpaceOnUse" x1="74.5286" y1="288.1433" x2="74.5286" y2="324.8333" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5615)">
                                 <stop offset="0" style="stop-color:#FFF465"></stop>
                                 <stop offset="1" style="stop-color:#FFE600"></stop>
                             </linearGradient>
                             <circle style="fill:url(#fb1_SVGID_9_);" cx="75.013" cy="211.296" r="25.474"></circle>
                             <g>
                                 <circle style="fill:#FFB92D;" cx="65.335" cy="201.618" r="5.271"></circle>
                                 <circle style="fill:#FFB92D;" cx="84.691" cy="201.618" r="5.271"></circle>
                                 <circle style="fill:#FFB92D;" cx="65.335" cy="220.984" r="5.271"></circle>
                                 <circle style="fill:#FFB92D;" cx="84.691" cy="220.984" r="5.271"></circle>
                             </g>
                         </svg>
                     </div>
                     <div class="space-4"></div>
                     <div class="ot-icon-box__content">
                         <h3 class="icon-box-title">GOAL <br> TRACKING</h3>
                         <div class="space-3"></div>
                         <div class="icon-box-des">Any of the goals including, temporary, short-term, long-term, etc. can be set through this module. One can update the progress by editing the entry manually.</div>
                     </div>
                 </div>
                 <div class="space-30 d-md-none"></div>
             </div>
             <div class="col-lg-3 col-md-6 col-sm-6 mb-4">
                 <div class="ot-icon-box services-list-icon services-h1 pr-4">
                     <div class="ot-icon-box__icon">
                         <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512.001 512.001" style="enable-background:new 0 0 512.001 512.001;" xml:space="preserve">
                             <linearGradient id="chart_h1_SVGID_1_" gradientUnits="userSpaceOnUse" x1="307.4912" y1="216.7054" x2="554.6512" y2="-30.4546" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#A7F3CE"></stop>
                                 <stop offset="1" style="stop-color:#61DB99"></stop>
                             </linearGradient>
                             <path style="fill:url(#chart_h1_SVGID_1_);" d="M340.366,164.133c93.488-1.428,169.792,72.153,171.602,165.634  c0.266,13.725-1.106,27.084-3.932,39.898c-4.786,21.697-7.631,43.776-7.631,65.995v42.948c0,6.58-5.334,11.914-11.914,11.914  h-42.948c-22.219,0-44.298,2.845-65.995,7.631c-12.813,2.826-26.172,4.198-39.897,3.932  c-93.48-1.809-167.061-78.111-165.635-171.597C175.407,239.238,249.117,165.527,340.366,164.133z"></path>
                             <linearGradient id="chart_h1_SVGID_2_" gradientUnits="userSpaceOnUse" x1="388.3985" y1="135.8026" x2="283.4185" y2="240.7726" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#61DB99;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#009E74"></stop>
                             </linearGradient>
                             <path style="fill:url(#chart_h1_SVGID_2_);" d="M340.366,164.133c93.488-1.428,169.792,72.153,171.602,165.634  c0.266,13.725-1.106,27.084-3.932,39.898c-4.786,21.697-7.631,43.776-7.631,65.995v42.948c0,6.58-5.334,11.914-11.914,11.914  h-42.948c-22.219,0-44.298,2.845-65.995,7.631c-12.813,2.826-26.172,4.198-39.897,3.932  c-93.48-1.809-167.061-78.111-165.635-171.597C175.407,239.238,249.117,165.527,340.366,164.133z"></path>
                             <linearGradient id="chart_h1_SVGID_3_" gradientUnits="userSpaceOnUse" x1="129.97" y1="332.7742" x2="390.92" y2="71.8242" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#62E1FB"></stop>
                                 <stop offset="1" style="stop-color:#00A2F3"></stop>
                             </linearGradient>
                             <path style="fill:url(#chart_h1_SVGID_3_);" d="M209.098,9.909C95.204,8.169,2.245,97.81,0.039,211.696  c-0.323,16.719,1.348,32.996,4.792,48.606c5.83,26.432,9.296,53.331,9.296,80.4v52.322c0,8.016,6.498,14.515,14.515,14.515h52.322  c27.068,0,53.967,3.466,80.4,9.296c15.61,3.443,31.886,5.115,48.605,4.791c113.884-2.205,203.525-95.161,201.789-209.053  C410.062,101.406,320.264,11.606,209.098,9.909z"></path>
                             <linearGradient id="chart_h1_SVGID_4_" gradientUnits="userSpaceOnUse" x1="179.0384" y1="218.1926" x2="41.6444" y2="355.5826" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#00A2F3;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#0075CD"></stop>
                             </linearGradient>
                             <path style="fill:url(#chart_h1_SVGID_4_);" d="M132.193,204.739c-5.816-6.18-14.048-10.061-23.206-10.061  c-17.613,0-31.891,14.278-31.891,31.891c0,9.157,3.88,17.389,10.061,23.206l68.794,68.794c5.817,6.18,14.049,10.061,23.206,10.061  c17.613,0,31.891-14.278,31.891-31.891c0-9.157-3.881-17.389-10.061-23.206L132.193,204.739z"></path>
                             <circle style="fill:#FFFFFF;" cx="108.986" cy="226.565" r="31.891"></circle>
                             <linearGradient id="chart_h1_SVGID_5_" gradientUnits="userSpaceOnUse" x1="268.8719" y1="218.196" x2="131.4819" y2="355.586" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#00A2F3;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#0075CD"></stop>
                             </linearGradient>
                             <path style="fill:url(#chart_h1_SVGID_5_);" d="M222.383,204.739c-5.816-6.18-14.048-10.061-23.206-10.061  c-17.613,0-31.891,14.278-31.891,31.891c0,9.157,3.88,17.389,10.061,23.206l68.794,68.794c5.817,6.18,14.049,10.061,23.206,10.061  c17.613,0,31.891-14.278,31.891-31.891c0-9.157-3.881-17.389-10.061-23.206L222.383,204.739z"></path>
                             <circle style="fill:#FFFFFF;" cx="199.178" cy="226.565" r="31.891"></circle>
                             <linearGradient id="chart_h1_SVGID_6_" gradientUnits="userSpaceOnUse" x1="358.7104" y1="218.1945" x2="221.3204" y2="355.5845" gradientTransform="matrix(1.0039 0 0 -1.0039 0.1922 516.5609)">
                                 <stop offset="0" style="stop-color:#00A2F3;stop-opacity:0"></stop>
                                 <stop offset="1" style="stop-color:#0075CD"></stop>
                             </linearGradient>
                             <path style="fill:url(#chart_h1_SVGID_6_);" d="M312.572,204.739c-5.816-6.18-14.048-10.061-23.206-10.061  c-17.613,0-31.891,14.278-31.891,31.891c0,9.157,3.881,17.389,10.061,23.206l68.794,68.794c5.817,6.18,14.049,10.061,23.206,10.061  c17.613,0,31.891-14.278,31.891-31.891c0-9.157-3.881-17.389-10.061-23.206L312.572,204.739z"></path>
                             <circle style="fill:#FFFFFF;" cx="289.371" cy="226.565" r="31.891"></circle>
                         </svg>
                     </div>
                     <div class="space-4"></div>
                     <div class="ot-icon-box__content">
                         <h3 class="icon-box-title pr-lg-5">Leads Management</h3>
                         <div class="space-3"></div>
                         <div class="icon-box-des">You can view all the generated leads through a Kanban and List view. Create pipelines and assign stages to various leads. You can manage the leads.</div>
                     </div>
                 </div>
             </div>



         </div>
         <div class="space-50"></div>
     </div>
 </section>

 <section class="about-h1">
     <div class="overlay"></div>
     <div class="space-80"></div>
     <div class="space-5"></div>
     <div class="container">
         <div class="row">
             <div class="col-xl-6 col-lg-6 align-self-center mb-5 mb-lg-0">
                 <div class="about-img-h1">
                     <img src="{{ asset('assets/landing/images/service-img-1.png') }}" alt="">
                 </div>
             </div>
             <div class="col-xl-5 offset-xl-1 col-lg-6 align-self-center">
                 <div class="about-detail-h1 z-index-1 position-relative">
                     <div class="ssub-yes text-left">
                         <div class="ot-heading">
                             <h2 class="ot-heading__title head01">Why <span class="span368">AlphaERP</span>?</h2>
                         </div>
                     </div>
                     <div class="space-10"></div>
                     <div class="space-5"></div>
                     <ul class="none-style list-s2">
                         <li>
                             <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                             <span>One system to meet all requirements.</span>
                         </li>
                         <li>
                             <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                             <span>Real-Time Tracking</span>
                         </li>
                         <li>
                             <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                             <span>Boosts Productivity</span>
                         </li>
                         <li>
                             <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                             <span> Adds to Your Bottom Line</span>
                         </li>
                         <li>
                             <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                             <span> Helps Your Business Grow</span>
                         </li>
                         <li>
                             <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                             <span> Customers are More Satisfied as a Result</span>
                         </li>
                         <li>
                             <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                             <span> Automated Manufacturing ERP</span>
                         </li>
                     </ul>
                     <div class="space-10"></div>
                     <div class="space-5"></div>
                     <div class="ot-button">
                         <a href="{{ route('contact-us') }}" class="octf-btn octf-btn-second">Free Demo</a>
                     </div>
                 </div>
             </div>
         </div>
         <div class="space-100"></div>
         <div class="row">
             <div class="col-xl-5 col-lg-6 order-last order-lg-first">
                 <div class="space-40"></div>
                 <div class="ssub-yes">
                     <div class="ot-heading">
                         <h2 class="ot-heading__title head01">Why <span class="span368">Manufacturing ERP Software</span>?</h2>
                     </div>
                 </div>
                 <div class="space-20"></div>
                 <div class="space-5"></div>
                 <ul class="none-style list-s2">
                     <li>
                         <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                         <span>Manufacturing ERP Software make the system robust and standardized</span>
                     </li>
                     <li>
                         <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                         <span> Manufacturing ERP System increase the production efficiency as most of the Manufacturing ERP have automated BOM & Production Planning</span>
                     </li>
                     <li>
                         <span><i aria-hidden="true" class="fas fa-circle"></i></span>
                         <span>Manufacturing ERP is helpful for Vendor Selection, Keep Proper Inventory level, Historical data in most presentable manner</span>
                     </li>

                 </ul>
                 <div class="space-30"></div>
                 <div class="ot-position-left ot-vertical-align-top">
                     <div class="service-box">
                         <div class="service-box__number number-color-2">

                         </div>
                         <div class="service-box__content">


                         </div>
                     </div>
                 </div>
             </div>
             <div class="col-xl-5 col-lg-6 offset-xl-2">
                 <div class="about-img2-h1">
                     <img src="{{ asset('assets/landing/images/image2-home1.png') }}" alt="">
                 </div>
             </div>
         </div>
         <div class="space-100"></div>
     </div>
 </section>

 <section class="offer-h1">
     <div class="container">
         <div class="row">
             <div class="col-lg-12 text-center">
                 <div class="ssub-yes">
                     <div class="ot-heading">
                         <span class="ot-heading__sub">What we offer compare to Other ERP's</span>
                         <h2 class="ot-heading__title">Boost Your Digital Presence With AlphaERP</h2>
                     </div>
                 </div>
                 <div class="space-30"></div>
             </div>
         </div>
         <div class="row">
             <div class="col-12 col-md-6 mb-4">
                 <div class="card p-4">
                     <div class="card-body">
                         <h1 class="alpha">AlphaERP</h1>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon01 pr-3 mt-2"></i>
                             <p class="p01">Both Dark and Light Mode Themes are Provided</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon01 pr-3 mt-2"></i>
                             <p class="p01">Meta Option for SEO is provided</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon01 pr-3 mt-2"></i>
                             <p class="p01">2 way google calender sync is provided</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon01 pr-3 mt-2"></i>
                             <p class="p01">Multiple OpenAI Model Integration</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon01 pr-3 mt-2"></i>
                             <p class="p01">Multiple Language Support provided</p>
                         </div>
                     </div>
                 </div>
             </div>
             <div class="col-12 col-md-6 mb-4">
                 <div class="card p-4">
                     <div class="card-body">
                         <h1 class="alpha">Other ERP's</h1>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon001 pr-3 mt-2"></i>
                             <p class="p01">Either Dark (or) Light Mode Themes are Provided</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon001 pr-3 mt-2"></i>
                             <p class="p01">No Meta Option for SEO</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon001 pr-3 mt-2"></i>
                             <p class="p01">1 way google calender sync is provided</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon001 pr-3 mt-2"></i>
                             <p class="p01">Limited OpenAI Model Integration</p>
                         </div>
                         <div class="d-flex flex-row manu001">
                             <i class="fa-solid fa-check icon001 pr-3 mt-2"></i>
                             <p class="p01">Limited Language Support</p>
                         </div>
                     </div>
                 </div>
             </div>

         </div>
 </section>
 <div class="d-flex flex-row justify-content-center mb-5 mt-4">
     <div class="ot-button">
         <a href="{{ route('features') }}" class="octf-btn octf-btn-main">See Our Features</a>
     </div>
 </div>



 <section class="testti-h1">
     <div class="container">
         <div class="row">
             <div class="col-lg-12 text-center">
                 <div class="ssub-yes">
                     <div class="ot-heading">
                         <span class="ot-heading__sub">What peoples say</span>
                         <h2 class="ot-heading__title">See What They Have to Say</h2>
                     </div>
                 </div>
                 <div class="space-40"></div>
             </div>
             <div class="col-lg-12">
                 <div class="ot-testimonial-slider ot-testimonial-s1 image-position-aside owl-theme owl-carousel">
                     <div class="ot-testimonial-s1__item">
                         <div class="tcontent">
                             <div class="ticon"><i class="ot-flaticon-quote"></i></div>
                             <h4 class="ttitle">Excelent!!</h4>
                             <div class="tdesc">« I am an advertiser, app developer, service provider or agency looking to reach the right customers and maximize. »</div>
                         </div>
                         <div class="tmeta flex-middle">
                             <img src="{{ asset('assets/landing/images/testimonial-1.png') }}" class="" alt="">
                             <div class="tinfo">
                                 <h6>Peter, Belgium</h6>
                                 <span>Developer</span>
                             </div>
                         </div>
                     </div>
                     <div class="ot-testimonial-s1__item">
                         <div class="tcontent">
                             <div class="ticon"><i class="ot-flaticon-quote"></i></div>
                             <h4 class="ttitle">Wonderful!!!</h4>
                             <div class="tdesc">« I am an advertiser, app developer, service provider or agency looking to reach the right customers and maximize. »</div>
                         </div>
                         <div class="tmeta flex-middle">
                             <img src="{{ asset('assets/landing/images/testimonial-2.png') }}" class="" alt="">
                             <div class="tinfo">
                                 <h6>Amandah, Italy</h6>
                                 <span>Developer</span>
                             </div>
                         </div>
                     </div>
                     <div class="ot-testimonial-s1__item">
                         <div class="tcontent">
                             <div class="ticon"><i class="ot-flaticon-quote"></i></div>
                             <h4 class="ttitle">Perfectly!!!</h4>
                             <div class="tdesc">« I am an advertiser, app developer, service provider or agency looking to reach the right customers and maximize. »</div>
                         </div>
                         <div class="tmeta flex-middle">
                             <img src="{{ asset('assets/landing/images/testimonial-1.png') }}" class="" alt="">
                             <div class="tinfo">
                                 <h6>Andrew, New York</h6>
                                 <span>Developer</span>
                             </div>
                         </div>
                     </div>
                     <div class="ot-testimonial-s1__item">
                         <div class="tcontent">
                             <div class="ticon"><i class="ot-flaticon-quote"></i></div>
                             <h4 class="ttitle">Wonderful!!!</h4>
                             <div class="tdesc">« I am an advertiser, app developer, service provider or agency looking to reach the right customers and maximize. »</div>
                         </div>
                         <div class="tmeta flex-middle">
                             <img src="{{ asset('assets/landing/images/testimonial-2.png') }}" class="" alt="">
                             <div class="tinfo">
                                 <h6>Amandah, Italy</h6>
                                 <span>Developer</span>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
         <div class="space-80"></div>
         <div class="space-5"></div>
     </div>
 </section>

 <section class="about-cta">
     <div class="container">
         <div class="space-100 d-none d-lg-block"></div>
         <div class="space-100"></div>
         <div class="row">
             <div class="col-xl-8 offset-xl-2 text-center">
                 <div class="ssub-yes px-lg-5 mx-lg-5">
                     <div class="ot-heading">
                         <span class="ot-heading__sub">Works together</span>
                         <h2 class="ot-heading__title">I Want to Know More About Scaling Readiness!</h2>
                     </div>
                 </div>
                 <div class="space-20"></div>
                 <p class="px-lg-5 mx-lg-5">But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently.</p>
                 <div class="space-20"></div>
                 <div class="ot-button">
                     <a href="#" class="octf-btn octf-btn-main">Let’s Get Started</a>
                 </div>
             </div>
         </div>
         <div class="space-100 d-none d-lg-block"></div>
         <div class="space-100"></div>
     </div>
 </section>
 @endsection