 @extends('layouts.landing') 
 @section('page-title') 
 {{ __('Manage Leave Type') }} 
 @endsection
 @section('content') 
   <div id="content" class="site-content">
            <div class="page-header dtable text-center">
                <div class="dcell">
                    <div class="container">
                        <h1 class="page-title">Pricing Plans</h1>
                        <ul id="breadcrumbs" class="breadcrumbs none-style">
                            <li><a href="index.html">Home</a></li>
                            <li class="active">Pricing Plans</li>
                        </ul> 
                    </div>
                </div>
            </div>
        </div>

        <section class="pricing-sec-1">
            <div class="container">
                <div class="space-90"></div>
                <div class="row">
                    <div class="col-lg-6 offset-lg-3 text-center px-lg-0">
                        <div class="ssub-yes">
                            <div class="ot-heading">
                                <span class="ot-heading__sub">Pricing Plans v1</span>
                                <h2 class="ot-heading__title">The Right Price for You</h2>
                            </div>
                        </div>
                        <div class="space-10"></div>
                        <div class="space-5"></div>
                        <p>Get control and visibility over spending. Try any plan free for 30 days with no lock-in commitments.</p>
                        <div class="space-20"></div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    @if($plans)
                    @foreach ($plans as $plan)
                        
                    
                    <div class="col-lg-4 col-md-6 mb-5 mb-lg-0">
                        <div class="ot-pricing-table --second-color pricing-border radius-main">
                            <div class="ot-pricing-table__header">
                                <h3 class="ot-pricing-table__title">{{ $plan->name }}</h3>
                                <span class="ot-pricing-table__subtitle">{{ $plan->description}}</span>
                            </div>
                            <div class="ot-pricing-table__price">
                                <div class="ot-pricing-table__price-main">{{(env('CURRENCY_SYMBOL') ? env('CURRENCY_SYMBOL') : '$')}}{{ number_format($plan->price) }}</div>
                                <span class="ot-pricing-table__price-extra">{{$plan->duration_limit}} {{$plan->duration}}</span>
                            </div>
                            <div class="ot-pricing-table__features-list">
                                <ul>
                                    <li>{{ $plan->max_users }} Users </li>
                                    <li>{{ $plan->max_customers }} Customers </li>
                                    <li>{{ $plan->max_venders }} Vendors </li>
                                    <li>{{ $plan->max_clients }} Clients </li>
                                    <li> {{ ($plan->storage_limit == -1)?'Unlimited' : $plan->storage_limit.'MB' }} Storage</li>
                                    @if($plan->crm == 1)
                                    <li>CRM</li>
                                    @endif
                                    @if($plan->hrm == 1)
                                    <li>HRM</li>
                                    @endif
                                    @if($plan->account == 1)
                                    <li>Account Manager</li>
                                    @endif
                                    @if($plan->project == 1)
                                    <li>Project Manager</li>
                                    @endif
                                    @if($plan->pos == 1)
                                    <li>POS</li>
                                    @endif
                                    @if($plan->chatgpt == 1)
                                    <li>Chat GPT</li>
                                    @endif
                                    
                                    
                                </ul>
                            </div>
                            <div class="space-70"></div>
                            <div class="ot-pricing-table__footer">
                                <a href="{{ route('company.register',$plan->id) }}" class="octf-btn octf-btn-second --price-link-trial">Subscribe Now</a>
                                {{-- <a href="#" class="octf-price-link-detail">Learn More</a> --}}
                            </div>
                        </div>
                    </div>
                    @endforeach
                    @endif
                    
                </div>
              
               
               
             
                <div class="space-100"></div>
            </div>
        </section>

@endsection
